<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\data\ActiveDataProvider;
use app\models\Tour;
use app\models\Booking;
use app\models\User;

class AdminController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        // Упрощаем проверку - разрешаем доступ только если пользователь вошел
                        // и у него email админа (как в ТЗ)
                        'matchCallback' => function ($rule, $action) {
                            if (Yii::$app->user->isGuest) {
                                return false;
                            }
                            $user = Yii::$app->user->identity;
                            // Проверяем email как в ТЗ: admintour@mail.ru
                            return $user->email === 'admintour@mail.ru';
                        }
                    ],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        return $this->render('index');
    }

    public function actionTours()
    {
        $dataProvider = new ActiveDataProvider([
            'query' => Tour::find(),
            'pagination' => ['pageSize' => 20],
        ]);

        return $this->render('tours', [
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionBookings()
    {
        $dataProvider = new ActiveDataProvider([
            'query' => Booking::find()->with('user', 'tour'),
            'pagination' => ['pageSize' => 20],
            'sort' => ['defaultOrder' => ['created_at' => SORT_DESC]],
        ]);

        return $this->render('bookings', [
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionUsers()
    {
        $dataProvider = new ActiveDataProvider([
            'query' => User::find(),
            'pagination' => ['pageSize' => 20],
            'sort' => ['defaultOrder' => ['created_at' => SORT_DESC]],
        ]);

        return $this->render('users', [
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionUpdateBooking($id)
    {
        $model = Booking::findOne($id);

        if (!$model) {
            throw new \yii\web\NotFoundHttpException('Заявка не найдена.');
        }

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Статус заявки обновлен.');
            return $this->redirect(['bookings']);
        }

        return $this->render('update-booking', [
            'model' => $model,
        ]);
    }

    public function actionUpdateUser($id)
    {
        $model = User::findOne($id);

        if (!$model) {
            throw new \yii\web\NotFoundHttpException('Пользователь не найден.');
        }

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Данные пользователя обновлены.');
            return $this->redirect(['users']);
        }

        return $this->render('update-user', [
            'model' => $model,
        ]);
    }

    public function actionCreateTour()
    {
        $model = new Tour();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Тур создан.');
            return $this->redirect(['tours']);
        }

        return $this->render('create-tour', [
            'model' => $model,
        ]);
    }

    public function actionUpdateTour($id)
    {
        $model = Tour::findOne($id);

        if (!$model) {
            throw new \yii\web\NotFoundHttpException('Тур не найден.');
        }

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Тур обновлен.');
            return $this->redirect(['tours']);
        }

        return $this->render('update-tour', [
            'model' => $model,
        ]);
    }

    public function actionDeleteTour($id)
    {
        $model = Tour::findOne($id);

        if ($model) {
            $model->delete();
            Yii::$app->session->setFlash('success', 'Тур удален.');
        }

        return $this->redirect(['tours']);
    }
}