<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\Booking;
use app\models\Tour;

class BookingController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $bookings = Booking::find()
            ->where(['user_id' => Yii::$app->user->id])
            ->with('tour')
            ->orderBy(['created_at' => SORT_DESC])
            ->all();

        return $this->render('index', [
            'bookings' => $bookings,
        ]);
    }

    public function actionCreate($tour_id = null)
    {
        $model = new Booking();
        $model->user_id = Yii::$app->user->id;

        if ($tour_id) {
            $model->tour_id = $tour_id;
        }

        $tours = Tour::find()
            ->select(['id', 'title'])
            ->indexBy('id')
            ->column();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Заявка успешно создана.');
            return $this->redirect(['index']);
        }

        return $this->render('create', [
            'model' => $model,
            'tours' => $tours,
        ]);
    }
}