<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\web\ErrorAction;

class SiteController extends Controller
{
    public function actions()
    {
        return [
            'error' => [
                'class' => ErrorAction::class,
            ],
        ];
    }

    public function actionIndex()
    {
        // Получаем 3 последних тура
        $tours = \app\models\Tour::find()
            ->orderBy(['id' => SORT_DESC])
            ->limit(3)
            ->all();

        // Получаем 3 последних отзыва
        $reviews = \app\models\Review::find()
            ->with(['user', 'tour'])
            ->orderBy(['created_at' => SORT_DESC])
            ->limit(3)
            ->all();

        // Получаем туры для отзыва (если пользователь авторизован)
        $userBookingTours = [];
        if (!Yii::$app->user->isGuest) {
            $userBookingTours = \app\models\Booking::find()
                ->select(['tour.id', 'tour.title'])
                ->innerJoin('tour', 'booking.tour_id = tour.id')
                ->where([
                    'booking.user_id' => Yii::$app->user->id,
                    'booking.status' => 'accepted'
                ])
                ->andWhere(['not exists',
                    (new \yii\db\Query())
                        ->from('review r')
                        ->where('r.user_id = booking.user_id AND r.tour_id = booking.tour_id')
                ])
                ->asArray()
                ->all();
        }

        return $this->render('index', [
            'tours' => $tours,
            'reviews' => $reviews,
            'userBookingTours' => $userBookingTours,
        ]);
    }

    public function actionContact()
    {
        return $this->render('contact');
    }
}