<?php

namespace app\models;

use yii\db\ActiveRecord;

class Booking extends ActiveRecord
{
    public static function tableName()
    {
        return 'booking';
    }

    public function rules()
    {
        return [
            [['user_id', 'tour_id', 'date', 'participants', 'payment_method'], 'required'],
            ['date', 'date', 'format' => 'php:Y-m-d'],
            ['participants', 'integer', 'min' => 1, 'max' => 50],
            ['payment_method', 'in', 'range' => ['cash', 'card', 'online']],
            ['status', 'default', 'value' => 'new'],
            ['status', 'in', 'range' => ['new', 'accepted', 'rejected']],
            ['wishes', 'string', 'max' => 500],
        ];
    }

    public function attributeLabels()
    {
        return [
            'tour_id' => 'Тур',
            'date' => 'Дата поездки',
            'participants' => 'Количество участников',
            'payment_method' => 'Способ оплаты',
            'wishes' => 'Дополнительные пожелания',
            'status' => 'Статус',
        ];
    }

    public function getTour()
    {
        return $this->hasOne(Tour::class, ['id' => 'tour_id']);
    }

    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

    public function getStatusLabel()
    {
        $statuses = [
            'new' => 'Новая',
            'accepted' => 'Принята',
            'rejected' => 'Отклонена',
        ];

        return $statuses[$this->status] ?? $this->status;
    }
}