<?php

namespace app\models;

use yii\db\ActiveRecord;

class Review extends ActiveRecord
{
    public static function tableName()
    {
        return 'review';
    }

    public function rules()
    {
        return [
            [['tour_id', 'text', 'rating'], 'required'],
            ['tour_id', 'exist', 'targetClass' => Tour::class, 'targetAttribute' => 'id'],
            ['rating', 'integer', 'min' => 1, 'max' => 5],
            ['text', 'string', 'max' => 1000],
        ];
    }

    public function attributeLabels()
    {
        return [
            'text' => 'Отзыв',
            'rating' => 'Оценка',
        ];
    }

    public function getTour()
    {
        return $this->hasOne(Tour::class, ['id' => 'tour_id']);
    }

    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }
}