<?php

namespace app\models;

use yii\db\ActiveRecord;

class Tour extends ActiveRecord
{
    public static function tableName()
    {
        return 'tour';
    }

    public function rules()
    {
        return [
            [['title', 'description', 'program', 'price'], 'required'],
            ['price', 'number', 'min' => 0],
            ['image', 'string', 'max' => 255],
            ['title', 'string', 'max' => 255],
        ];
    }

    public function attributeLabels()
    {
        return [
            'title' => 'Название',
            'description' => 'Описание',
            'program' => 'Программа',
            'price' => 'Стоимость',
            'image' => 'Изображение',
        ];
    }
}