<?php
use yii\helpers\Html;
use yii\helpers\Url;

// Получаем текущий статус из URL
$currentStatus = Yii::$app->request->get('status', '');
?>

<div class="container">
    <h1>Управление заявками</h1>

    <?php if (Yii::$app->session->hasFlash('success')): ?>
        <div class="alert success"><?= Yii::$app->session->getFlash('success') ?></div>
    <?php endif; ?>

    <!-- Простой фильтр -->
    <div style="background: white; padding: 1.5rem; border-radius: 12px; box-shadow: var(--shadow); margin-bottom: 2rem;">
        <h3>Фильтр заявок</h3>
        <form method="get" style="display: flex; gap: 1rem; align-items: end; flex-wrap: wrap;">
            <div>
                <label for="status-filter">Статус</label>
                <select name="status" id="status-filter" style="padding: 8px 12px; border: 1px solid #cbd5e1; border-radius: 8px;">
                    <option value="">Все</option>
                    <option value="new" <?= $currentStatus === 'new' ? 'selected' : '' ?>>Новая</option>
                    <option value="accepted" <?= $currentStatus === 'accepted' ? 'selected' : '' ?>>Принята</option>
                    <option value="rejected" <?= $currentStatus === 'rejected' ? 'selected' : '' ?>>Отклонена</option>
                </select>
            </div>
            <button type="submit" class="btn">Применить</button>
            <?php if ($currentStatus): ?>
                <a href="<?= Url::to(['admin/booking']) ?>" class="btn btn-outline">Сбросить</a>
            <?php endif; ?>
        </form>
    </div>

    <?php if (empty($bookings)): ?>
        <div style="text-align: center; padding: 3rem; background: #f8fafc; border-radius: 12px; color: var(--light-text);">
            <p>Заявок не найдено.</p>
        </div>
    <?php else: ?>
        <div class="bookings-list" style="display: grid; gap: 1.5rem; margin: 2rem 0;">
            <?php foreach ($bookings as $booking): ?>
                <div class="review-item" style="padding: 1.5rem; border-radius: 12px; background: white; box-shadow: var(--shadow);">
                    <h3 style="margin: 0 0 0.8rem; color: var(--primary);">
                        Заявка #<?= $booking->id ?> — <?= Html::encode($booking->tour->title ?? 'Тур удалён') ?>
                    </h3>

                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(180px, 1fr)); gap: 1rem; margin-bottom: 1rem;">
                        <div>
                            <strong>Пользователь:</strong><br>
                            <?= Html::encode($booking->user->fio ?? '—') ?><br>
                            <small><?= Html::encode($booking->user->email ?? '—') ?></small>
                        </div>
                        <div>
                            <strong>Дата:</strong><br>
                            <?= Yii::$app->formatter->asDate($booking->date) ?>
                        </div>
                        <div>
                            <strong>Участников:</strong><br>
                            <?= $booking->participants ?>
                        </div>
                        <div>
                            <strong>Оплата:</strong><br>
                            <?= Html::encode($booking->payment_method) ?>
                        </div>
                    </div>

                    <!-- Обновление статуса -->
                    <div style="display: flex; gap: 0.75rem; align-items: center; margin-top: 1rem;">
                        <span><strong>Статус:</strong></span>
                        <form method="post" style="display: inline;"
                              onsubmit="return confirm('Обновить статус заявки #<?= $booking->id ?>?')">
                            <?= Html::hiddenInput(Yii::$app->request->csrfParam, Yii::$app->request->csrfToken) ?>
                            <?= Html::hiddenInput('id', $booking->id) ?>
                            <?= Html::dropDownList('status', $booking->status, [
                                    'new' => 'Новая',
                                    'accepted' => 'Принята',
                                    'rejected' => 'Отклонена'
                            ], ['class' => 'status-select']) ?>
                            <button type="submit" class="btn btn-small" style="font-size: 0.9rem; margin-left: 0.5rem;">Сохранить</button>
                        </form>
                    </div>

                    <?php if (!empty($booking->wishes)): ?>
                        <div style="margin-top: 1rem; padding: 1rem; background: #f1f5f9; border-radius: 8px; font-size: 0.95rem;">
                            <strong>Пожелания:</strong><br>
                            <?= Html::encode($booking->wishes) ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div style="text-align: center; margin: 2rem 0;">
        <a href="<?= Url::to(['/']) ?>" class="btn">На главную</a>
    </div>
</div>

<!-- Лёгкие стили для селекта -->
<style>
    .status-select {
        padding: 6px 10px;
        border: 1px solid #cbd5e1;
        border-radius: 6px;
        font-size: 0.9rem;
    }
</style>