<div class="container">
    <h1>Отзывы</h1>
    <?php use yii\helpers\Html;
    use yii\helpers\Url;

    if (empty($reviews)): ?>
        <p>Нет отзывов.</p>
    <?php else: ?>
        <div class="reviews-list" style="margin: 2rem 0;">
            <?php foreach ($reviews as $r): ?>
                <div class="review-item" style="margin-bottom: 1.5rem;">
                    <div style="display: flex; justify-content: space-between; align-items: start;">
                        <div>
                            <strong><?= Html::encode($r->user->fio ?? '—') ?></strong> •
                            <span class="review-rating"><?= str_repeat('★', $r->rating) ?></span>
                            <p style="margin: 0.5rem 0;"><?= Html::encode($r->text) ?></p>
                            <small style="color: var(--light-text);">Тур: <?= Html::encode($r->tour->title) ?></small>
                        </div>
                        <form method="post" style="display: inline;" onsubmit="return confirm('Удалить отзыв?')">
                            <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">
                            <input type="hidden" name="id" value="<?= $r->id ?>">
                            <button type="submit" class="btn btn-small btn-danger">Удалить</button>
                        </form>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
    <a href="<?= Url::to(['/admin']) ?>" class="btn">Назад</a>
</div>