<?php
use yii\helpers\Html;
use yii\helpers\Url;
?>

<div class="container">
    <h1>Пользователи</h1>

    <?php if (empty($users)): ?>
        <div style="text-align: center; padding: 3rem; background: #f8fafc; border-radius: 12px; margin: 2rem 0; color: var(--light-text);">
            <p>Нет зарегистрированных пользователей.</p>
        </div>
    <?php else: ?>
        <div style="overflow-x: auto; margin: 2rem 0;">
            <table class="admin-table" style="width: 100%; border-collapse: collapse; background: white; border-radius: 12px; overflow: hidden; box-shadow: var(--shadow);">
                <thead>
                <tr style="background: #f1f5f9;">
                    <th style="padding: 1rem; text-align: left; border-bottom: 1px solid #e2e8f0;">ФИО</th>
                    <th style="padding: 1rem; text-align: left; border-bottom: 1px solid #e2e8f0;">Email</th>
                    <th style="padding: 1rem; text-align: left; border-bottom: 1px solid #e2e8f0;">Телефон</th>
                    <th style="padding: 1rem; text-align: left; border-bottom: 1px solid #e2e8f0;">Паспорт</th>
                    <th style="padding: 1rem; text-align: left; border-bottom: 1px solid #e2e8f0;">Действия</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($users as $user): ?>
                    <tr style="border-bottom: 1px solid #f1f5f9;">
                        <td style="padding: 1rem;"><?= Html::encode($user->fio) ?></td>
                        <td style="padding: 1rem;"><?= Html::encode($user->email) ?></td>
                        <td style="padding: 1rem;"><?= Html::encode($user->phone) ?></td>
                        <td style="padding: 1rem;"><?= Html::encode($user->passport) ?></td>
                        <td style="padding: 1rem;">
                            <a href="<?= Url::to(['admin/delete-user', 'id' => $user->id]) ?>"
                               class="btn btn-small btn-danger"
                               onclick="return confirm('Удалить пользователя <?= Html::encode($user->fio) ?>?')">Удалить</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>

    <div style="text-align: center; margin: 2rem 0;">
        <a href="<?= Url::to(['/']) ?>" class="btn">На главную</a>
    </div>
</div>