<?php
use yii\helpers\Html;
use yii\helpers\Url;
?>

<div class="container" style="max-width: 600px; margin: 4rem auto;">
    <div class="card" style="padding: 2rem;">
        <h2 class="text-center mb-4">Регистрация</h2>

        <?php if (Yii::$app->session->hasFlash('success')): ?>
            <div style="background: #dfd; color: #050; padding: 1rem; border-radius: 6px; margin-bottom: 1rem;">
                <?= Yii::$app->session->getFlash('success') ?>
            </div>
        <?php endif; ?>

        <form method="post">
            <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">

            <div class="grid grid-cols-2 gap-3">
                <div class="form-group">
                    <label>ФИО</label>
                    <?= Html::textInput('User[fio]', $model->fio, ['required' => true]) ?>
                    <?= Html::error($model, 'fio', ['style' => 'color: #c00; font-size: 0.9rem;']) ?>
                </div>

                <div class="form-group">
                    <label>Телефон</label>
                    <?= Html::textInput('User[phone]', $model->phone, ['required' => true, 'placeholder' => '+7(999)999-99-99']) ?>
                    <?= Html::error($model, 'phone', ['style' => 'color: #c00; font-size: 0.9rem;']) ?>
                </div>

                <div class="form-group col-span-2">
                    <label>Email</label>
                    <?= Html::textInput('User[email]', $model->email, ['type' => 'email', 'required' => true]) ?>
                    <?= Html::error($model, 'email', ['style' => 'color: #c00; font-size: 0.9rem;']) ?>
                </div>

                <div class="form-group">
                    <label>Паспорт</label>
                    <?= Html::textInput('User[passport]', $model->passport, ['required' => true, 'placeholder' => '10 цифр']) ?>
                    <?= Html::error($model, 'passport', ['style' => 'color: #c00; font-size: 0.9rem;']) ?>
                </div>

                <div class="form-group">
                    <label>Адрес</label>
                    <?= Html::textInput('User[address]', $model->address, ['required' => true]) ?>
                    <?= Html::error($model, 'address', ['style' => 'color: #c00; font-size: 0.9rem;']) ?>
                </div>

                <div class="form-group">
                    <label>Пароль</label>
                    <?= Html::passwordInput('User[password]', null, ['required' => true]) ?>
                    <?= Html::error($model, 'password', ['style' => 'color: #c00; font-size: 0.9rem;']) ?>
                </div>

                <div class="form-group">
                    <label>Повторите пароль</label>
                    <?= Html::passwordInput('User[password_repeat]', null, ['required' => true]) ?>
                    <?= Html::error($model, 'password_repeat', ['style' => 'color: #c00; font-size: 0.9rem;']) ?>
                </div>

                <div class="form-group col-span-2">
                    <label style="display: flex; align-items: center; gap: 0.5rem;">
                        <?= Html::checkbox('User[agree_rules]', $model->agree_rules, ['value' => 1]) ?>
                        <span>Согласен с правилами</span>
                    </label>
                    <?= Html::error($model, 'agree_rules', ['style' => 'color: #c00; font-size: 0.9rem;']) ?>
                </div>
            </div>

            <button type="submit" class="btn mt-3" style="width: 100%;">Зарегистрироваться</button>
        </form>

        <div class="text-center mt-4">
            <p class="text-gray">Уже есть аккаунт?</p>
            <a href="<?= Url::to(['/auth/login']) ?>" class="btn btn-secondary">Войти</a>
        </div>
    </div>
</div>