<?php
use yii\helpers\Html;
use yii\helpers\Url;
?>

<div class="container">
    <h1 style="margin-bottom: 2rem;">Мои заявки</h1>

    <?php if (empty($bookings)): ?>
        <div style="text-align: center; padding: 3rem; background: #f8f9fa; border-radius: 8px; color: #999;">
            <p>У вас пока нет заявок</p>
            <a href="<?= Url::to(['/tour/index']) ?>" class="btn" style="margin-top: 1rem;">Выбрать тур</a>
        </div>
    <?php else: ?>
        <div style="display: grid; gap: 1rem;">
            <?php foreach ($bookings as $booking): ?>
                <div style="background: white; padding: 1.5rem; border-radius: 8px; border: 1px solid #eee;">
                    <h3 style="margin-bottom: 0.5rem; color: #2c3e50;"><?= Html::encode($booking->tour->title ?? 'Тур удален') ?></h3>

                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem; margin-top: 1rem;">
                        <div>
                            <strong>Дата:</strong> <?= Yii::$app->formatter->asDate($booking->date) ?>
                        </div>
                        <div>
                            <strong>Участников:</strong> <?= $booking->participants ?>
                        </div>
                        <div>
                            <strong>Статус:</strong>
                            <?php
                            $statusColors = [
                                'new' => ['bg' => '#e3f2fd', 'text' => '#1565c0'],
                                'accepted' => ['bg' => '#e8f5e9', 'text' => '#2e7d32'],
                                'rejected' => ['bg' => '#ffebee', 'text' => '#c62828']
                            ];
                            $color = $statusColors[$booking->status] ?? ['bg' => '#f5f5f5', 'text' => '#616161'];
                            ?>
                            <span style="display: inline-block; padding: 0.25rem 0.75rem; border-radius: 4px; background: <?= $color['bg'] ?>; color: <?= $color['text'] ?>; font-size: 0.9rem;">
                                <?= Html::encode($booking->getStatusLabel()) ?>
                            </span>
                        </div>
                        <div>
                            <strong>Оплата:</strong> <?= Html::encode($booking->payment_method) ?>
                        </div>
                    </div>

                    <?php if (!empty($booking->wishes)): ?>
                        <div style="margin-top: 1rem; padding-top: 1rem; border-top: 1px solid #eee;">
                            <strong>Пожелания:</strong> <?= Html::encode($booking->wishes) ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div style="text-align: center; margin-top: 2rem;">
        <a href="<?= Url::to(['/tour/index']) ?>" class="btn">Назад к каталогу</a>
    </div>
</div>