<?php
use yii\helpers\Html;
use yii\helpers\Url;
?>

<h2>Оставить отзыв о туре: <?= Html::encode($tour->title) ?></h2>

<form method="post" class="review-form">
    <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">

    <div class="form-group">
        <label>Оценка</label>
        <div class="rating-input">
            <?php for ($i = 5; $i >= 1; $i--): ?>
                <label>
                    <input type="radio" name="Review[rating]" value="<?= $i ?>" required>
                    <?= str_repeat('★', $i) ?>
                </label>
            <?php endfor; ?>
        </div>
        <div class="error"><?= Html::error($model, 'rating') ?></div>
    </div>

    <div class="form-group">
        <label>Ваш отзыв</label>
        <textarea name="Review[text]" rows="5" maxlength="1000" required><?= Html::encode($model->text ?? '') ?></textarea>
        <div class="error"><?= Html::error($model, 'text') ?></div>
    </div>

    <button type="submit" class="btn">Отправить отзыв</button>
    <a href="<?= Url::to(['tour/view', 'id' => $tour->id]) ?>" class="btn btn-outline">Назад</a>
</form>