<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\LinkPager;
?>

<div class="container mt-6">
    <div class="mb-6">
        <h1 class="mb-2">Каталог туров</h1>
        <p class="text-gray">Найдено: <?= $pages->totalCount ?> туров</p>
    </div>

    <!-- Filter -->
    <div class="card mb-6" style="padding: 1.5rem;">
        <h3 class="mb-3">Фильтры</h3>
        <form method="get" class="grid grid-cols-4 gap-3">
            <div>
                <label>Цена от</label>
                <input type="number" name="min_price" value="<?= $minPrice ?? '' ?>" placeholder="0">
            </div>
            <div>
                <label>Цена до</label>
                <input type="number" name="max_price" value="<?= $maxPrice ?? '' ?>" placeholder="100000">
            </div>
            <div class="col-span-2" style="display: flex; align-items: flex-end; gap: 1rem;">
                <button type="submit" class="btn">Применить</button>
                <?php if ($minPrice || $maxPrice): ?>
                    <a href="<?= Url::to(['/tour']) ?>" class="btn btn-secondary">Сбросить</a>
                <?php endif; ?>
            </div>
        </form>
    </div>

    <!-- Tours grid -->
    <?php if (empty($tours)): ?>
        <div class="card" style="padding: 3rem; text-align: center;">
            <p class="text-gray mb-3">Туры не найдены</p>
            <a href="<?= Url::to(['/tour']) ?>" class="btn btn-secondary">Сбросить фильтры</a>
        </div>
    <?php else: ?>
        <div class="grid grid-cols-3 gap-4 mb-6">
            <?php foreach ($tours as $tour): ?>
                <div class="card">
                    <?php if ($tour->image): ?>
                        <div style="height: 200px; overflow: hidden;">
                            <img src="uploads/<?= Html::encode($tour->image) ?>"
                                 alt="<?= Html::encode($tour->title) ?>"
                                 style="width: 100%; height: 100%; object-fit: cover;">
                        </div>
                    <?php endif; ?>
                    <div style="padding: 1.5rem;">
                        <h3 class="mb-2"><?= Html::encode($tour->title) ?></h3>
                        <p class="text-gray mb-3" style="font-size: 0.9rem;"><?= Html::encode(mb_substr($tour->description, 0, 100)) ?>...</p>
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <span style="font-weight: 600; font-size: 1.25rem;"><?= number_format($tour->price, 0, '', ' ') ?> ₽</span>
                            <a href="<?= Url::to(['tour/view', 'id' => $tour->id]) ?>" class="btn">Подробнее</a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <!-- Pagination -->
    <?php if ($pages->totalCount > $pages->pageSize): ?>
        <div class="text-center">
            <?= LinkPager::widget([
                'pagination' => $pages,
                'options' => ['class' => 'pagination'],
                'linkContainerOptions' => ['style' => 'margin: 0 0.25rem;'],
                'linkOptions' => ['class' => 'btn btn-secondary'],
                'activePageCssClass' => 'btn',
                'disabledPageCssClass' => 'btn btn-secondary',
            ]) ?>
        </div>
    <?php endif; ?>
</div>